﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;

//access resource.resx
using System.Resources;

//our data access class library
using DataAccess;

/// <summary>
/// Summary description for CNoteTitleData
/// </summary>
public class CNoteTitleDataXfer : CData
{
    /// <summary>
    /// US:6002 constructor
    /// </summary>
    /// <param name="data"></param>
    public CNoteTitleDataXfer(CData data)
        : base(data)
    {
        //constructors are not inherited in c#!
    }


    /// <summary>
    /// US:6002 save a MDWS note title to the central database
    /// </summary>
    /// <param name="lXferSystemID"></param>
    /// <param name="lNoteTitleID"></param>
    /// <param name="strNoteTitleLabel"></param>
    /// <param name="strNoteTitleDetails"></param>
    /// <returns></returns>
    public CStatus SaveNoteTitle(long lXferSystemID,
                                 long lNoteTitleTag,
                                 string strNoteTitleLabel,
                                 long lIsConsult)
    {
        CStatus status = new CStatus();

        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(base.SessionID,
                                                          base.ClientIP,
                                                          base.UserID);

        
        pList.AddInputParameter("pi_nXferSystemID", lXferSystemID);
        pList.AddInputParameter("pi_nRegionID", this.RegionID); 
        pList.AddInputParameter("pi_nSiteID", this.SiteID);
        pList.AddInputParameter("pi_nNoteTitleTag", lNoteTitleTag);
        pList.AddInputParameter("pi_vNoteTitleLabel", strNoteTitleLabel);
        pList.AddInputParameter("pi_nIsConsult", lIsConsult);

        return DBConn.ExecuteOracleSP("PCK_XFER.XferNoteTitle", pList);
    }
}
